<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van RCMR_IN010014NL - Revise consent, dissent, or override Request</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    <include href="coreschematron/attentionLine.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <include href="APF/RCMR_MT010001NL.sch"/>
    
    <pattern is-a="attentionLine" id="RCMR_IN010014NL-attentionLine">
        <param name="messagePatientId"
            value="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:subject2/hl7:consentDirective/hl7:subject/hl7:patient/hl7:id"/>
        <param name="attentionLineOptional" value="'false'"/>
    </pattern>
    
    <pattern is-a="transmission-wrapper" id="RCMR_IN010014NL-wrapper">
        <param name="element" value="hl7:RCMR_IN010014NL"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="RCMR_IN010014NL-controlAct">
        <param name="element" value="hl7:RCMR_IN010014NL/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:RCMR_IN010014NL/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:RCMR_IN010014NL/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <!-- ontvanger -->
        <rule context="hl7:RCMR_IN010014NL/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >Ontvanger moet de ZIM zijn.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>ControlActProcess</title>
        <rule context="hl7:ControlActProcess">
            <assert role="error" test="count(hl7:subject) = 1">ControlActProcess moet precies één subject bevatten.</assert>
        </rule>
        
        <title>ControlActProcess/overseer</title>
        <rule context="hl7:ControlActProcess/hl7:overseer/hl7:AssignedPerson/hl7:Organization[not(@nullFlavor or hl7:id/@nullFlavor)]">
            <assert role="error" test="../../../hl7:subject/hl7:registrationProcess/hl7:subject2/hl7:consentDirective/hl7:author2/hl7:responsibleParty/hl7:representedOrganization"
                >indien er een overseer/AssignedPerson/Organization is, moet responsibleParty/representedOrganization moet aanwezig zijn</assert>
        </rule>
    </pattern>

    <pattern>
        <title>RegistrationProcess</title>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess">
            <assert role="error" test="@moodCode='RQO'">registrationProcess/@moodCode moet 'RQO' zijn</assert>
            <assert role="error" test="count(hl7:subject2) = 1">registrationProcess moet precies één autorisatieprofiel bevatten.</assert>
        </rule>
        
        <title>RegistrationProcess/code</title>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:code">
            <assert role="error" test="@code='116116' and @codeSystem='2.16.840.1.113883.2.4.15.4'"
                >registrationProcess/code moet '116116' zijn uit codeSystem '2.16.840.1.113883.2.4.15.4'</assert>
        </rule>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:statusCode">
            <assert role="error" test="@code='active'">registrationProcess/statusCode moet 'active' zijn</assert>
        </rule>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:effectiveTime">
            <assert role="error" test="@nullFlavor='UNK'"
                >registrationProcess/effectiveTime moet nullFlavor='UNK' hebben. De ZIM bepaalt de registratiedatum.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:subject2/hl7:consentDirective">
        <assert role="warning" test="not(hl7:id)">consentDirective/id is niet van toepassing in berichten verstuurd door een GBx</assert>
        </rule>
    </pattern>

    <pattern is-a="RCMR_MT010001" id="RCMR_IN010014NL-RCMR_MT010001">
        <param name="element" value="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:subject2/hl7:consentDirective"/>
    </pattern>

    <pattern>
        <title>consentDirective</title>
    </pattern>
    

</schema>
